/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.sms.message;

import com.nokia.sms.entity.BindRespStatus;
import com.nokia.sms.entity.CommandId;
import com.nokia.sms.entity.DelBlkBody;
import com.nokia.sms.entity.DelBlkRespStatus;
import com.nokia.sms.exception.ParseException;
import com.nokia.sms.exception.PhoneNumberCanNotBeNullException;
import com.nokia.sms.message.MessageHeader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ClientMessageUtil {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");

    public static byte[] getSmitBindMessage(String systemId, String password) throws NoSuchAlgorithmException {
        MessageHeader header = new MessageHeader();
        header.setMessageLength(38);
        header.setCommandId(CommandId.SMIT_BIND);
        header.setSequenceNumber(0L);
        byte[] message = new byte[header.getMessageLength()];
        System.arraycopy(header.toByteArray(), 0, message, 0, 12);
        byte[] systemIdByteArray = systemId.getBytes();
        System.arraycopy(systemIdByteArray, 0, message, 12, systemIdByteArray.length);
        String authCodeString = password + dateFormat.format(new Date());
        System.out.println("authCodeString : " + authCodeString);
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        System.arraycopy(digest.digest(authCodeString.getBytes()), 0, message, 18, 20);
        return message;
    }

    public static byte[] getSmitDelBlkMessage(DelBlkBody delBlkBody, long sequenceNumber) throws PhoneNumberCanNotBeNullException {
        MessageHeader header = new MessageHeader();
        header.setMessageLength(27);
        header.setCommandId(CommandId.SMIT_DELBLK);
        header.setSequenceNumber(sequenceNumber);
        byte[] message = new byte[header.getMessageLength()];
        System.arraycopy(header.toByteArray(), 0, message, 0, 12);
        if (delBlkBody.getBlkNum() == null) {
            throw new PhoneNumberCanNotBeNullException();
        }
        byte[] blkNumByteArray = delBlkBody.getBlkNum().getBytes();
        System.arraycopy(blkNumByteArray, 0, message, 12, blkNumByteArray.length);
        message[24] = delBlkBody.getBlock_type();
        message[25] = delBlkBody.getBlk_type();
        message[26] = delBlkBody.getProvince_code();
        return message;
    }

    public static byte[] getSmitActiveTestMessage(long sequenceNumber) {
        MessageHeader header = new MessageHeader();
        header.setMessageLength(12);
        header.setCommandId(CommandId.SMIT_ACTIVE_TEST);
        header.setSequenceNumber(sequenceNumber);
        byte[] message = new byte[header.getMessageLength()];
        System.arraycopy(header.toByteArray(), 0, message, 0, 12);
        return message;
    }

    public static BindRespStatus parseSmitBindRespMessage(byte[] message) throws ParseException {
        MessageHeader header = MessageHeader.parse((byte[])message);
        if (header.getCommandId().equals((Object)CommandId.SMIT_BIND_RESP)) {
            return BindRespStatus.parse((byte)message[12]);
        }
        throw new ParseException("\u671f\u5f85 SMIT_BIND_RESP \u6d88\u606f,\u6536\u5230\u4e86 " + header.getCommandId() + " \u6d88\u606f");
    }

    public static DelBlkRespStatus parseSmitDelBlkRespMessage(byte[] message) throws ParseException {
        MessageHeader header = MessageHeader.parse((byte[])message);
        if (header.getCommandId().equals((Object)CommandId.SMIT_DELBLK_RESP)) {
            return DelBlkRespStatus.parse((byte)message[12]);
        }
        throw new ParseException("\u671f\u5f85 SMIT_DELBLK_RESP \u6d88\u606f,\u6536\u5230\u4e86 " + header.getCommandId() + " \u6d88\u606f");
    }

    public static long parseSmitActiveTestRespMessage(byte[] message) throws ParseException {
        MessageHeader header = MessageHeader.parse((byte[])message);
        if (CommandId.SMIT_ACTIVE_TEST_RESP.equals((Object)header.getCommandId())) {
            return header.getSequenceNumber();
        }
        throw new ParseException("\u671f\u5f85 SMIT_ACTIVE_TEST_RESP \u6d88\u606f,\u6536\u5230\u4e86 " + header.getCommandId() + " \u6d88\u606f");
    }
}

