/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.sms.service;

import com.nokia.sms.config.BlkConfig;
import com.nokia.sms.entity.BindRespStatus;
import com.nokia.sms.entity.DelBlkBody;
import com.nokia.sms.entity.DelBlkRespStatus;
import com.nokia.sms.exception.ConnectFailedException;
import com.nokia.sms.exception.ParseException;
import com.nokia.sms.message.ClientMessageUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;

@Service
public class SocketClientService {
    private static final Logger log = LoggerFactory.getLogger(SocketClientService.class);
    private final ThreadPoolTaskScheduler socketScheduler;
    volatile Socket socket;
    volatile InputStream inputStream;
    volatile OutputStream outputStream;
    volatile boolean connected;
    volatile long sequenceNumber;
    private static final long MAX_SEQUENCE_NUMBER = 0xFFFFFFFFL;
    volatile Future<?> heartbeatFuture;
    volatile String systemId = BlkConfig.getConfig((String)"blkServer.systemId");
    volatile String password = BlkConfig.getConfig((String)"blkServer.password");
    volatile String host = BlkConfig.getConfig((String)"blkServer.ipAddress");
    volatile int port = Integer.parseInt(BlkConfig.getConfig((String)"blkServer.port"));
    volatile int connectTimeout = Integer.parseInt(BlkConfig.getConfig((String)"blkServer.connectTimeout"));
    volatile long heartbeatDelay = Long.parseLong(BlkConfig.getConfig((String)"blkServer.heartbeatDelay"));

    public SocketClientService(ThreadPoolTaskScheduler socketScheduler) throws ConnectFailedException {
        this.socketScheduler = socketScheduler;
    }

    public boolean delBlk(String phoneNumber) {
        log.debug("\u51c6\u5907\u5220\u9664\u53f7\u7801 {} \u7684\u77ed\u4fe1\u9ed1\u540d\u5355\u8bb0\u5f55...", (Object)phoneNumber);
        Future future = this.socketScheduler.submit(() -> {
            boolean b;
            if (!this.connected) {
                this.connect();
            }
            DelBlkBody delBlkBody = new DelBlkBody(phoneNumber);
            long sequenceNumberSend = this.getNextSequence();
            byte[] smitDelBlk = ClientMessageUtil.getSmitDelBlkMessage((DelBlkBody)delBlkBody, (long)sequenceNumberSend);
            this.outputStream.write(smitDelBlk);
            this.outputStream.flush();
            log.debug("\u5df2\u53d1\u9001\u89e3\u9664\u9ed1\u540d\u5355\u6d88\u606f SMIT_DELBLK, \u5e8f\u5217\u53f7: {} -- {}", (Object)sequenceNumberSend, (Object)Arrays.toString(smitDelBlk));
            byte[] resp = new byte[13];
            this.inputStream.read(resp);
            log.debug("\u6536\u5230\u670d\u52a1\u5668\u56de\u590d... {}", (Object)Arrays.toString(resp));
            DelBlkRespStatus status = ClientMessageUtil.parseSmitDelBlkRespMessage((byte[])resp);
            boolean bl = b = status == DelBlkRespStatus.SUCCESS;
            if (b) {
                this.sequenceNumber = this.getNextSequence();
            }
            return b;
        });
        try {
            return (Boolean)future.get();
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u9ed1\u540d\u5355\u51fa\u9519...");
            e.printStackTrace();
            this.close();
            return false;
        }
    }

    public void connect() throws ConnectFailedException {
        try {
            this.socket = new Socket();
            InetAddress address = InetAddress.getByName(this.host);
            this.socket.connect(new InetSocketAddress(address, this.port), this.connectTimeout);
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
            byte[] smitBind = ClientMessageUtil.getSmitBindMessage((String)this.systemId, (String)this.password);
            this.outputStream.write(smitBind);
            this.outputStream.flush();
            log.debug("\u5df2\u53d1\u9001\u7ed1\u5b9a\u8bf7\u6c42\u6d88\u606f SMIT_BIND {}", (Object)Arrays.toString(smitBind));
            byte[] resp = new byte[13];
            int count = this.inputStream.read(resp);
            BindRespStatus status = ClientMessageUtil.parseSmitBindRespMessage((byte[])resp);
            log.debug("\u6536\u5230\u670d\u52a1\u5668\u56de\u590d...\u957f\u5ea6 {} \u5b57\u8282, \u72b6\u6001: {}--{}", new Object[]{count, status, Arrays.toString(resp)});
            if (BindRespStatus.SUCCESS.equals((Object)status)) {
                this.connected = true;
                log.info("\u5df2\u6210\u529f\u4e0e\u670d\u52a1\u7aef\u5efa\u7acb\u8fde\u63a5,\u5f00\u59cb\u5fc3\u8df3\u68c0\u6d4b");
                this.heartbeatFuture = this.socketScheduler.scheduleAtFixedRate(() -> this.heartbeat(), new Date(System.currentTimeMillis() + this.heartbeatDelay), this.heartbeatDelay);
                return;
            }
            log.error("\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a {}", (Object)status);
            this.close();
            throw new ConnectFailedException("\u8fde\u63a5\u5931\u8d25\uff0c\u72b6\u6001\u7801 : " + status);
        }
        catch (ParseException | IOException | NoSuchAlgorithmException e) {
            log.error("\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
            this.close();
            throw new ConnectFailedException(String.format("\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25, \u539f\u56e0\uff1a %s - %s", e.getClass().getName(), e.getMessage()));
        }
    }

    public void heartbeat() {
        try {
            long sequenceNumberSend = this.getNextSequence();
            byte[] smitActiveTest = ClientMessageUtil.getSmitActiveTestMessage((long)sequenceNumberSend);
            this.outputStream.write(smitActiveTest);
            this.outputStream.flush();
            log.debug("\u5df2\u53d1\u9001\u5fc3\u8df3\u6d88\u606f, \u5e8f\u5217\u53f7: {}", (Object)sequenceNumberSend);
            byte[] buffer = new byte[48];
            this.inputStream.read(buffer);
            long sequenceNumberReceive = ClientMessageUtil.parseSmitActiveTestRespMessage((byte[])buffer);
            log.debug("\u63a5\u6536\u5230\u670d\u52a1\u5668\u8fd4\u56de\u7684\u5fc3\u8df3\u6d88\u606f, \u5e8f\u5217\u53f7: {}", (Object)sequenceNumberReceive);
            if (sequenceNumberReceive == sequenceNumberSend) {
                this.sequenceNumber = this.getNextSequence();
            } else {
                log.error("\u5fc3\u8df3\u4e71\u5e8f\uff0c\u5c06\u5173\u95ed\u8fde\u63a5...\u53d1\u9001 {} \u63a5\u6536 {} ", (Object)sequenceNumberSend, (Object)sequenceNumberReceive);
                this.close();
            }
        }
        catch (ParseException | IOException e) {
            log.error("\u5fc3\u8df3\u51fa\u9519,\u5c06\u5173\u95ed\u8fde\u63a5... {}({})", (Object)e.getClass().getName(), (Object)e.getMessage());
            this.close();
        }
    }

    public void close() {
        this.heartbeatFuture.cancel(true);
        this.sequenceNumber = 0L;
        this.connected = false;
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.inputStream = null;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.outputStream = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.socket = null;
        }
    }

    private long getNextSequence() {
        if (this.sequenceNumber < 0xFFFFFFFFL) {
            return this.sequenceNumber + 1L;
        }
        return 0L;
    }
}

