/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.common.io;

import java.nio.ByteBuffer;

public class ByteArrayUtil {
    public static int parseInteger(byte[] buffer, int offset) {
        byte[] byteArr = new byte[4];
        int size = buffer.length - offset;
        if (size >= 4) {
            System.arraycopy(buffer, offset, byteArr, 0, 4);
        } else {
            System.arraycopy(buffer, offset, byteArr, 4 - size, size);
        }
        return ByteBuffer.wrap(byteArr).getInt();
    }

    public static long parseUnsignedInteger(byte[] buffer, int offset) {
        byte[] byteArr = new byte[8];
        int size = buffer.length - offset;
        if (size >= 4) {
            System.arraycopy(buffer, offset, byteArr, 4, 4);
        } else {
            System.arraycopy(buffer, offset, byteArr, 8 - size, size);
        }
        return ByteBuffer.wrap(byteArr).getLong();
    }

    public static byte[] toByteArray(int value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(value);
        return buffer.array();
    }

    public static byte[] toByteArray(long value) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        return buffer.array();
    }
}

