/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.sms.message;

import com.nokia.common.io.ByteArrayUtil;
import com.nokia.sms.entity.CommandId;
import com.nokia.sms.exception.ParseException;
import java.util.Arrays;

public class MessageHeader {
    private int messageLength;
    private CommandId commandId;
    private long sequenceNumber;

    public byte[] toByteArray() {
        byte[] header = new byte[12];
        System.arraycopy(ByteArrayUtil.toByteArray((int)this.messageLength), 0, header, 0, 4);
        System.arraycopy(ByteArrayUtil.toByteArray((long)this.commandId.value), 4, header, 4, 4);
        System.arraycopy(ByteArrayUtil.toByteArray((long)this.sequenceNumber), 4, header, 8, 4);
        return header;
    }

    public static MessageHeader parse(byte[] message) throws ParseException {
        byte[] header = Arrays.copyOf(message, 12);
        MessageHeader messageHeader = new MessageHeader();
        messageHeader.setMessageLength(ByteArrayUtil.parseInteger((byte[])header, (int)0));
        long commandIdValue = ByteArrayUtil.parseUnsignedInteger((byte[])header, (int)4);
        CommandId commandId = CommandId.parse((long)commandIdValue);
        if (null == commandId) {
            throw new ParseException("\u65e0\u6cd5\u8bc6\u522b Command_Id : " + commandIdValue);
        }
        messageHeader.setCommandId(commandId);
        messageHeader.setSequenceNumber(ByteArrayUtil.parseUnsignedInteger((byte[])header, (int)8));
        return messageHeader;
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public CommandId getCommandId() {
        return this.commandId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setMessageLength(int messageLength) {
        this.messageLength = messageLength;
    }

    public void setCommandId(CommandId commandId) {
        this.commandId = commandId;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageHeader)) {
            return false;
        }
        MessageHeader other = (MessageHeader)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getMessageLength() != other.getMessageLength()) {
            return false;
        }
        if (this.getSequenceNumber() != other.getSequenceNumber()) {
            return false;
        }
        CommandId this$commandId = this.getCommandId();
        CommandId other$commandId = other.getCommandId();
        return !(this$commandId == null ? other$commandId != null : !this$commandId.equals(other$commandId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMessageLength();
        long $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + (int)($sequenceNumber >>> 32 ^ $sequenceNumber);
        CommandId $commandId = this.getCommandId();
        result = result * 59 + ($commandId == null ? 43 : $commandId.hashCode());
        return result;
    }

    public String toString() {
        return "MessageHeader(messageLength=" + this.getMessageLength() + ", commandId=" + this.getCommandId() + ", sequenceNumber=" + this.getSequenceNumber() + ")";
    }
}

