/*
 * Decompiled with CFR 0.152.
 */
package cn.chinaunicom.open.common.utils;

import cn.chinaunicom.open.annotation.COMPParam;
import cn.chinaunicom.open.common.CompLogger;
import cn.chinaunicom.open.common.exceptions.COMPParamException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    public static String map2JsonString(Map map) {
        return JSONObject.toJSONString((Object)map);
    }

    public static JSONObject getJsonObjectFromObject(Object object) {
        if (object == null) {
            throw new COMPParamException("\u88ab\u8f6c\u6362\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        COMPParam compParam = object.getClass().getAnnotation(COMPParam.class);
        if (compParam == null) {
            CompLogger.warn(object.getClass().getName() + "\uff1aclass\u7f3a\u5c11\u80fd\u529b\u5e73\u53f0\u53c2\u6570\u6ce8\u89e3\u914d\u7f6eCOMPParam");
            return JsonUtil.getJsonObjectFromObjectWithAnnotation(object);
        }
        return JsonUtil.getJsonObjectFromObjectWithAnnotation(object);
    }

    public static JSONObject getJsonObjectFromObjectWithAnnotation(Object object) {
        if (object == null) {
            return null;
        }
        JSONObject node = new JSONObject();
        Class<?> clazz = object.getClass();
        Field[] fields = clazz.getDeclaredFields();
        if (fields.length > 0) {
            for (Field field : fields) {
                COMPParam compParam = field.getAnnotation(COMPParam.class);
                if (compParam == null) continue;
                String newKey = compParam.paramName();
                Object valueObject = JsonUtil.getFieldValueByName(field.getName(), object);
                if (valueObject == null && !compParam.enableNull()) continue;
                if (valueObject instanceof Map) {
                    node.put(newKey, valueObject);
                    continue;
                }
                if (valueObject instanceof List) {
                    List valueList = (List)valueObject;
                    ArrayList list = new ArrayList();
                    for (int i = 0; i < valueList.size(); ++i) {
                        Object o = valueList.get(i);
                        if (JsonUtil.isLeaf(o.getClass())) {
                            list.add(o);
                            continue;
                        }
                        list.add(JsonUtil.getJsonObjectFromObjectWithAnnotation(o));
                    }
                    node.put(newKey, list);
                    continue;
                }
                if (JsonUtil.isLeaf(valueObject)) {
                    node.put(newKey, valueObject);
                    continue;
                }
                node.put(newKey, (Object)JsonUtil.getJsonObjectFromObjectWithAnnotation(valueObject));
            }
        }
        return node;
    }

    public static Object getObjectFromJsonString(Class clazz, JSONObject jsonObject) {
        try {
            if (Map.class.isAssignableFrom(clazz)) {
                if (jsonObject != null) {
                    return jsonObject.getInnerMap();
                }
                return null;
            }
            COMPParam rspParam = clazz.getAnnotation(COMPParam.class);
            if (rspParam == null) {
                CompLogger.warn(clazz.getName() + "\uff1aclass\u7f3a\u5c11\u80fd\u529b\u5e73\u53f0\u53c2\u6570\u6ce8\u89e3\u914d\u7f6eCOMPParam");
                return JsonUtil.getObjectFromJsonStringWithAnnotation(clazz, jsonObject);
            }
            return JsonUtil.getObjectFromJsonStringWithAnnotation(clazz, jsonObject);
        }
        catch (IllegalAccessException e) {
            CompLogger.error("\u8fd4\u56de\u62a5\u6587\u8f6c\u6362\u5bf9\u8c61\u51fa\u9519", e);
            throw new COMPParamException("\u8fd4\u56de\u62a5\u6587\u8f6c\u6362\u5bf9\u8c61\u51fa\u9519", e);
        }
        catch (InstantiationException e) {
            CompLogger.error("\u8fd4\u56de\u62a5\u6587\u8f6c\u6362\u5bf9\u8c61\u51fa\u9519", e);
            throw new COMPParamException("\u8fd4\u56de\u62a5\u6587\u8f6c\u6362\u5bf9\u8c61\u51fa\u9519", e);
        }
    }

    private static Object getObjectFromJsonStringWithAnnotation(Class clazz, JSONObject jsonObject) throws IllegalAccessException, InstantiationException {
        if (jsonObject == null) {
            return null;
        }
        Object rspParamObject = clazz.newInstance();
        Field[] fields = clazz.getDeclaredFields();
        if (fields.length > 0) {
            for (Field field : fields) {
                COMPParam compParam = field.getAnnotation(COMPParam.class);
                if (compParam == null) continue;
                String key = compParam.paramName();
                Object valueObject = jsonObject.get((Object)key);
                field.setAccessible(true);
                if (valueObject == null) {
                    field.set(rspParamObject, null);
                    continue;
                }
                if (JsonUtil.isLeaf(field.getType())) {
                    field.set(rspParamObject, valueObject);
                    continue;
                }
                if (List.class.isAssignableFrom(field.getType())) {
                    JSONArray jsonArray = jsonObject.getJSONArray(key);
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        Class clazz1 = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                        if (JsonUtil.isLeaf(clazz1)) {
                            list.add(jsonArray.get(i));
                            continue;
                        }
                        list.add(JsonUtil.getObjectFromJsonStringWithAnnotation(clazz1, jsonArray.getJSONObject(i)));
                    }
                    field.set(rspParamObject, list);
                    continue;
                }
                if (Map.class.isAssignableFrom(field.getType())) {
                    field.set(rspParamObject, jsonObject.getJSONObject(key).getInnerMap());
                    continue;
                }
                field.set(rspParamObject, JsonUtil.getObjectFromJsonStringWithAnnotation(field.getType(), jsonObject.getJSONObject(key)));
            }
        }
        return rspParamObject;
    }

    private static boolean isLeaf(Object object) {
        return object instanceof String || object instanceof Integer || object instanceof Character || object instanceof Short || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof Byte;
    }

    private static boolean isLeaf(Class clazz) {
        return String.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Short.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || Byte.class.isAssignableFrom(clazz);
    }

    public static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            CompLogger.error(e.getMessage(), e);
            return null;
        }
    }
}

