/*
 * Decompiled with CFR 0.152.
 */
package cn.chinaunicom.open.urlconnection.impl;

import cn.chinaunicom.open.common.CompLogger;
import cn.chinaunicom.open.common.exceptions.COMPException;
import cn.chinaunicom.open.common.utils.JsonUtil;
import cn.chinaunicom.open.common.utils.StringUtil;
import cn.chinaunicom.open.urlconnection.impl.AbstractConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpConnection
extends AbstractConnection {
    public HttpConnection() {
    }

    public HttpConnection(String method, String url, Map httpRequestHeaders) {
        super(method, url, httpRequestHeaders);
    }

    public HttpConnection(String method, String url, Map<String, Object> params, Map httpRequestHeaders) {
        super(method, url, JsonUtil.map2JsonString(params), httpRequestHeaders);
    }

    public HttpConnection(String method, String url, String requestContext, Map httpRequestHeaders) {
        super(method, url, requestContext, httpRequestHeaders);
    }

    @Override
    public String doConnect() {
        HttpURLConnection connection = null;
        try {
            boolean enableRequestBody;
            URL reqURL = new URL(this.url);
            connection = (HttpURLConnection)reqURL.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod(this.method);
            connection.setUseCaches(false);
            Set keys = this.httpRequestHeaders.keySet();
            for (String key : keys) {
                connection.setRequestProperty(key, (String)this.httpRequestHeaders.get(key));
            }
            connection.connect();
            boolean bl = enableRequestBody = this.method.equals("POST") || this.method.equals("PUT") || this.method.equals("DELETE") && this.paramString != null;
            if (enableRequestBody) {
                OutputStream out = connection.getOutputStream();
                String content = this.paramString;
                out.write(content.getBytes("UTF-8"));
                out.flush();
                out.close();
            }
            if (connection.getResponseCode() == 200) {
                String responeStr;
                String string = responeStr = StringUtil.readStream(connection.getInputStream());
                return string;
            }
            try {
                CompLogger.error("Request Error! ResponseCode;" + connection.getResponseCode());
                throw new IOException("Request Error! ResponseCode;" + connection.getResponseCode());
            }
            catch (IOException e) {
                throw new COMPException(e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

