/*
 * Decompiled with CFR 0.152.
 */
package cn.chinaunicom.open.nlgxptconnection.impl;

import cn.chinaunicom.open.common.CompLogger;
import cn.chinaunicom.open.common.exceptions.COMPCompressException;
import cn.chinaunicom.open.common.utils.CompressUtil;
import cn.chinaunicom.open.common.utils.JsonUtil;
import cn.chinaunicom.open.common.utils.StringUtil;
import cn.chinaunicom.open.common.utils.UrlUtil;
import cn.chinaunicom.open.nlgxptconnection.COMPConnectionContext;
import cn.chinaunicom.open.nlgxptconnection.impl.AbstractCOMPConnection;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class COMPJsonConnection
extends AbstractCOMPConnection {
    public COMPJsonConnection() {
        this.contentType = "application/json;charset=UTF-8";
    }

    public COMPJsonConnection(String appId, String appSecret) {
        super(appId, appSecret);
        this.contentType = "application/json;charset=UTF-8";
    }

    protected String getRequestContext(Object params, boolean isCompress) {
        JSONObject busiParamObject = params instanceof Map ? (JSONObject)JSONObject.toJSON((Object)params) : JsonUtil.getJsonObjectFromObject(params);
        JSONObject compParamObject = new JSONObject();
        JSONObject uniBssHead = new JSONObject();
        Date date = Calendar.getInstance().getTime();
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS").format(date);
        String transId = new SimpleDateFormat("yyyyMMddHHmmssSSS" + COMPJsonConnection.getRandomNumber()).format(date);
        uniBssHead.put("APP_ID", (Object)this.appId);
        uniBssHead.put("TIMESTAMP", (Object)timeStamp);
        uniBssHead.put("TRANS_ID", (Object)transId);
        uniBssHead.put("TOKEN", COMPJsonConnection.getToken(this.appId, this.appSecret, timeStamp, transId));
        compParamObject.put("UNI_BSS_HEAD", (Object)uniBssHead);
        if (isCompress) {
            try {
                String compress = CompressUtil.compress(busiParamObject.toJSONString());
                JSONObject mediaInfo = new JSONObject();
                mediaInfo.put("MEDIA_INFO", (Object)compress);
                compParamObject.put("UNI_BSS_ATTACHED", (Object)mediaInfo);
                compParamObject.put("UNI_BSS_BODY", (Object)"");
            }
            catch (IOException e) {
                CompLogger.error("\u8bf7\u6c42\u53c2\u6570\u5bf9\u8c61\u538b\u7f29\u5931\u8d25", e);
                throw new COMPCompressException("\u538b\u7f29\u62a5\u6587\u5931\u8d25", e);
            }
        } else {
            compParamObject.put("UNI_BSS_BODY", (Object)busiParamObject);
        }
        return compParamObject.toJSONString();
    }

    protected String getResponseContext(String responseContext) {
        JSONObject responseObj;
        if (StringUtil.isNotEmpty(responseContext) && (responseObj = JSONObject.parseObject((String)responseContext)).getJSONObject("UNI_BSS_ATTACHED") != null && StringUtil.isNotEmpty(responseObj.getJSONObject("UNI_BSS_ATTACHED").getString("MEDIA_INFO"))) {
            String mediaInfo = responseObj.getJSONObject("UNI_BSS_ATTACHED").getString("MEDIA_INFO");
            String paramString = null;
            try {
                paramString = CompressUtil.uncompress(mediaInfo);
            }
            catch (IOException e) {
                CompLogger.error("\u54cd\u5e94\u62a5\u6587\u89e3\u538b\u7f29\u51fa\u9519\uff1a", e);
                throw new COMPCompressException("\u54cd\u5e94\u62a5\u6587\u89e3\u538b\u7f29\u5931\u8d25", e);
            }
            JSONObject paramObject = JSONObject.parseObject((String)paramString);
            responseObj.put("UNI_BSS_BODY", (Object)paramObject);
            responseObj.getJSONObject("UNI_BSS_ATTACHED").put("MEDIA_INFO", (Object)"");
            return responseObj.toString();
        }
        return responseContext;
    }

    protected COMPConnectionContext parseContext(String url, String requestContext, String responseContext) {
        COMPConnectionContext compConnectionContext = new COMPConnectionContext();
        if (StringUtil.isNotEmpty(requestContext)) {
            JSONObject requestObj = JSONObject.parseObject((String)requestContext);
            JSONObject header = requestObj.getJSONObject("UNI_BSS_HEAD");
            compConnectionContext.setRequestContext(requestContext);
            compConnectionContext.setTransId(header.getString("TRANS_ID"));
            compConnectionContext.setTimestamp(header.getString("TIMESTAMP"));
            JSONObject responseObj = JSONObject.parseObject((String)responseContext);
            header = responseObj.getJSONObject("UNI_BSS_HEAD");
            compConnectionContext.setResponseContext(responseContext);
            compConnectionContext.setRespCode(header.getString("RESP_CODE"));
            compConnectionContext.setRespDesc(header.getString("RESP_DESC"));
        } else if (StringUtil.isNotEmpty(url)) {
            compConnectionContext.setTransId(UrlUtil.getParamFromUrlByName(url, "TRANS_ID"));
            compConnectionContext.setTimestamp(UrlUtil.getParamFromUrlByName(url, "TIMESTAMP"));
            compConnectionContext.setResponseContext(responseContext);
            JSONObject responseObj = JSONObject.parseObject((String)responseContext);
            compConnectionContext.setRespCode(responseObj.getString("RESP_CODE"));
            compConnectionContext.setRespDesc(responseObj.getString("RESP_DESC"));
        }
        return compConnectionContext;
    }
}

