/*
 * Decompiled with CFR 0.152.
 */
package cn.chinaunicom.open.nlgxptconnection.impl;

import cn.chinaunicom.open.common.CompLogger;
import cn.chinaunicom.open.common.utils.MD5Util;
import cn.chinaunicom.open.nlgxptconnection.COMPConnection;
import cn.chinaunicom.open.nlgxptconnection.COMPConnectionContext;
import cn.chinaunicom.open.urlconnection.Connection;
import cn.chinaunicom.open.urlconnection.impl.AbstractConnection;
import cn.chinaunicom.open.urlconnection.impl.HttpConnection;
import cn.chinaunicom.open.urlconnection.impl.HttpsConnection;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCOMPConnection
implements COMPConnection {
    protected String appId;
    protected String appSecret;
    protected String contentType;

    public AbstractCOMPConnection() {
    }

    public AbstractCOMPConnection(String appId, String appSecret) {
        this.appId = appId;
        this.appSecret = appSecret;
    }

    protected abstract String getRequestContext(Object var1, boolean var2);

    protected abstract String getResponseContext(String var1);

    protected abstract COMPConnectionContext parseContext(String var1, String var2, String var3);

    public COMPConnectionContext excute(String method, String url) {
        return this.excute(method, url, "", false);
    }

    public COMPConnectionContext excute(String method, String url, String requestContext) {
        return this.excute(method, url, requestContext, false);
    }

    public COMPConnectionContext excute(String method, String url, String requestContext, boolean isCompressed) {
        HashMap<String, String> selfDefHeaders = new HashMap<String, String>();
        selfDefHeaders.put("Content-Type", this.contentType);
        selfDefHeaders.put("Accept-Encoding", isCompressed ? "gzip" : "");
        CompLogger.info("[COMP-REQUEST] Request-Time: " + new Date() + " Request-Method: " + method + " Request-URL: " + url + (requestContext == null ? "" : " Request-Context: " + requestContext));
        Connection connection = this.getConnection(method, url, requestContext, selfDefHeaders);
        COMPConnectionContext compConnectionContext = null;
        try {
            String responseContext = this.getResponseContext(connection.doConnect());
            compConnectionContext = this.parseContext(url, requestContext, responseContext);
            CompLogger.info("[COMP-RESPONSE] Response-Time: " + new Date() + " Response-Context: " + responseContext);
        }
        catch (IOException e) {
            CompLogger.error("REQUEST COMP ERROR!", e);
        }
        return compConnectionContext;
    }

    public COMPConnectionContext excute(String method, String url, Object params) {
        return this.excute(method, url, params, false);
    }

    public COMPConnectionContext excute(String method, String url, Object params, boolean isCompressed) {
        return this.excute(method, url, this.getRequestContext(params, isCompressed), isCompressed);
    }

    protected Connection getConnection(String method, String url, String requestContext, Map selfDefHeaders) {
        int index = url.indexOf("://");
        String protocolType = url.substring(0, index).toUpperCase();
        AbstractConnection connection = requestContext == null ? (protocolType.equals("HTTP") ? new HttpConnection(method, url, selfDefHeaders) : new HttpsConnection(method, url, selfDefHeaders)) : (protocolType.equals("HTTP") ? new HttpConnection(method, url, requestContext, selfDefHeaders) : new HttpsConnection(method, url, requestContext, selfDefHeaders));
        return connection;
    }

    protected static int getRandomNumber() {
        return (int)((Math.random() * 9.0 + 1.0) * 100000.0);
    }

    protected static Object getToken(String appId, String appSecret, String timeStamp, String transId) {
        String beforeEncode = "APP_ID" + appId + "TIMESTAMP" + timeStamp + "TRANS_ID" + transId + appSecret;
        return MD5Util.md5encode(beforeEncode);
    }
}

