/*
 * Decompiled with CFR 0.152.
 */
package cn.chinaunicom.open.urlconnection.impl;

import cn.chinaunicom.open.common.exceptions.COMPException;
import cn.chinaunicom.open.common.utils.JsonUtil;
import cn.chinaunicom.open.common.utils.StringUtil;
import cn.chinaunicom.open.urlconnection.impl.AbstractConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpsConnection
extends AbstractConnection {
    HostnameVerifier ignoreHostnameVerifier = new HostnameVerifier(){

        public boolean verify(String s, SSLSession sslsession) {
            return true;
        }
    };
    private static TrustManager myX509TrustManager;

    public HttpsConnection() {
    }

    public HttpsConnection(String method, String url, Map httpRequestHeaders) {
        super(method, url, httpRequestHeaders);
    }

    public HttpsConnection(String method, String url, Map<String, Object> params, Map httpRequestHeaders) {
        super(method, url, JsonUtil.map2JsonString(params), httpRequestHeaders);
    }

    public HttpsConnection(String method, String url, String requestContext, Map httpRequestHeaders) {
        super(method, url, requestContext, httpRequestHeaders);
    }

    private static void trustAllHttpsCertificates() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllManager()};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    @Override
    public String doConnect() {
        HttpURLConnection connection = null;
        try {
            boolean enableRequestBody;
            URL reqURL = new URL(this.url);
            connection = (HttpsURLConnection)reqURL.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod(this.method);
            connection.setUseCaches(false);
            Set keys = this.httpRequestHeaders.keySet();
            for (String key : keys) {
                connection.setRequestProperty(key, (String)this.httpRequestHeaders.get(key));
            }
            ((HttpsURLConnection)connection).setHostnameVerifier(this.ignoreHostnameVerifier);
            HttpsURLConnection.setDefaultSSLSocketFactory(HttpsConnection.createSSL());
            connection.connect();
            boolean bl = enableRequestBody = (this.method.equals("POST") || this.method.equals("PUT")) && this.paramString != null;
            if (enableRequestBody) {
                OutputStream out = connection.getOutputStream();
                String content = this.paramString;
                out.write(content.getBytes("UTF-8"));
                out.flush();
                out.close();
            }
            if (connection.getResponseCode() == 200) {
                String responeStr;
                String string = responeStr = StringUtil.readStream(connection.getInputStream());
                return string;
            }
            try {
                throw new IOException("\u8bf7\u6c42\u5931\u8d25 HTTP CODE:" + connection.getResponseCode());
            }
            catch (IOException e) {
                throw new COMPException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new COMPException(e);
            }
            catch (KeyManagementException e) {
                throw new COMPException(e);
            }
            catch (NoSuchProviderException e) {
                throw new COMPException(e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static SSLSocketFactory createSSL() throws NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException {
        TrustManager[] tm = new TrustManager[]{myX509TrustManager};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, tm, null);
        SSLSocketFactory ssf = sslContext.getSocketFactory();
        return ssf;
    }

    static {
        try {
            HttpsConnection.trustAllHttpsCertificates();
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        myX509TrustManager = new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        };
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

