/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.service;

import com.nokia.dao.AreaDao;
import com.nokia.dao.UserDao;
import com.nokia.pojo.Area;
import com.nokia.pojo.Role;
import com.nokia.pojo.User;
import com.nokia.vo.flow.FlowRoleVo;
import com.nokia.vo.flow.FlowUserVo;
import com.nokia.vo.flow.UserTreeReq;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowService {
    private final UserDao userDao;
    private final AreaDao areaDao;

    @Autowired
    public FlowService(UserDao userDao, AreaDao areaDao) {
        this.userDao = userDao;
        this.areaDao = areaDao;
    }

    public List<FlowRoleVo> findRoleList(String username) {
        return this.userDao.findRoleList(username);
    }

    public List<FlowRoleVo> findRoleList() {
        return this.userDao.findRoleList2();
    }

    public List<FlowUserVo> findToPage() {
        return this.userDao.findToPage();
    }

    public FlowUserVo getByLoginId(String loginId) {
        return this.userDao.getFlowUserVoByLoginId(loginId);
    }

    public FlowUserVo getByUserId(Integer userId) {
        return this.userDao.getFlowUserVoByUserId(userId);
    }

    public List<Integer> findRoleIdByUserId(Integer userId) {
        return this.userDao.findRoleIdByUserId(userId);
    }

    public List<Integer> findUserIdByRoleId(Integer roleId) {
        return this.userDao.findUserIdByRoleId(roleId);
    }

    public List<FlowUserVo> findAuthorizedUser(String loginId, Integer roleId, String userName) {
        return this.userDao.findAuthorizedUser(loginId, roleId, userName);
    }

    public List<Role> getRoleCityByUserId(Integer userId) {
        return this.userDao.getRoleCityByUserId(userId);
    }

    public List<Map<String, Object>> getUserTree(UserTreeReq userTreeReq) {
        List queryRoles;
        ArrayList<Integer> cityIds = new ArrayList<Integer>();
        List<Area> areas = new ArrayList<Area>();
        List list = queryRoles = userTreeReq.getRole() == null || userTreeReq.getRole().size() == 0 ? null : userTreeReq.getRole();
        if (userTreeReq.getCity() == -1 || queryRoles == null) {
            areas = this.areaDao.getAll();
        } else {
            areas.add(this.areaDao.getByAreaId(-1));
            areas.add(this.areaDao.getByAreaId(userTreeReq.getCity().intValue()));
            areas.addAll(this.areaDao.getByParentId(userTreeReq.getCity().intValue()));
        }
        if (userTreeReq.getCity() == -1) {
            cityIds = null;
        } else {
            cityIds.add(-1);
            cityIds.add(userTreeReq.getCity());
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<Integer, Integer> top = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> second = new HashMap<Integer, Integer>();
        for (int i = 0; i < areas.size(); ++i) {
            LinkedHashMap<String, Object> map2;
            LinkedHashMap<String, Object> map1;
            if (((Area)areas.get(i)).getTypeCode() == 1) {
                map1 = new LinkedHashMap<String, Object>();
                map1.put("name", ((Area)areas.get(i)).getAreaName());
                map1.put("child", new ArrayList());
                result.add(map1);
                top.put(((Area)areas.get(i)).getAreaId(), i);
                map2 = new LinkedHashMap<String, Object>();
                map2.put("name", "\u7701\u516c\u53f8");
                map2.put("child", new ArrayList());
                ((List)map1.get("child")).add(map2);
                continue;
            }
            if (((Area)areas.get(i)).getTypeCode() == 2) {
                map1 = new LinkedHashMap();
                map1.put("name", ((Area)areas.get(i)).getAreaName());
                map1.put("child", new ArrayList());
                result.add(map1);
                top.put(((Area)areas.get(i)).getAreaId(), i);
                map2 = new LinkedHashMap();
                map2.put("name", "\u5e02\u516c\u53f8");
                map2.put("child", new ArrayList());
                ((List)map1.get("child")).add(map2);
                continue;
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", ((Area)areas.get(i)).getAreaName());
            map.put("child", new ArrayList());
            List list2 = (List)((Map)result.get((Integer)top.get(((Area)areas.get(i)).getParentId()))).get("child");
            list2.add(map);
            second.put(((Area)areas.get(i)).getAreaId(), list2.size() - 1);
        }
        List users = this.userDao.getByRoleIds(queryRoles, cityIds);
        LinkedHashMap<Area, List> userMap = new LinkedHashMap<Area, List>();
        for (User user : users) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            Area area = user.getArea() == null ? user.getCity() : user.getArea();
            map.put("name", area.getAreaName());
            map.put("userName", user.getUserName());
            map.put("userId", user.getUserId());
            map.put("child", new ArrayList());
            List userList = userMap.getOrDefault(area, new ArrayList());
            userList.add(map);
            userMap.put(area, userList);
        }
        for (Map.Entry entry : userMap.entrySet()) {
            if (((Area)entry.getKey()).getTypeCode() < 3) {
                List list3 = (List)((Map)result.get((Integer)top.get(((Area)entry.getKey()).getAreaId()))).get("child");
                ((Map)list3.get(0)).put("child", entry.getValue());
                continue;
            }
            List list2 = (List)((Map)result.get((Integer)top.get(((Area)entry.getKey()).getParentId()))).get("child");
            ((Map)list2.get((Integer)second.get(((Area)entry.getKey()).getAreaId()))).put("child", entry.getValue());
        }
        for (Map map : result) {
            List list1 = (List)map.get("child");
            for (int i = 0; i < list1.size(); ++i) {
                List list2 = (List)((Map)list1.get(i)).get("child");
                if (list2.size() != 0) continue;
                list1.remove(i);
                --i;
            }
        }
        return result;
    }
}

