/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.controller;

import com.nokia.common.R;
import com.nokia.pojo.User;
import com.nokia.service.AclService;
import com.nokia.vo.DapingUserVo;
import com.nokia.vo.FenxiUserVo;
import com.nokia.vo.HeidiankuUserVo;
import com.nokia.vo.LiuchengUserVo;
import com.nokia.vo.TokenVo;
import com.nokia.vo.YuceUserVo;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class VerificationController {
    private static final Logger log = LoggerFactory.getLogger(VerificationController.class);
    @Autowired
    private AclService aclService;
    @Value(value="${dop.redirect.url}")
    private String dopRedirectUrl;
    @Value(value="${top.redirect.url}")
    private String topRedirectUrl;

    @PostMapping(value={"/verification"})
    public R verifySystem(@RequestBody TokenVo tokenEntity) {
        log.debug("\u8f93\u5165\u53c2\u6570: {}", (Object)tokenEntity);
        User userEntity = this.aclService.verifySystem(tokenEntity.getToken(), tokenEntity.getFromSystem());
        log.debug("\u8f93\u51fa\u7528\u6237\u4fe1\u606f: {}", (Object)userEntity);
        HashMap<String, String> map = new HashMap<String, String>();
        if (tokenEntity.getFromSystem().equalsIgnoreCase("top")) {
            map.put("redirect", this.topRedirectUrl);
        } else if (tokenEntity.getFromSystem().equalsIgnoreCase("dop")) {
            map.put("redirect", this.dopRedirectUrl);
        } else {
            switch (tokenEntity.getSystem().trim().toLowerCase()) {
                case "daping": {
                    map.put("redirect", this.dopRedirectUrl);
                    break;
                }
                default: {
                    map.put("redirect", this.topRedirectUrl);
                }
            }
        }
        if (userEntity == null) {
            return R.error().data(map).message("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        switch (tokenEntity.getSystem().trim().toLowerCase()) {
            case "liucheng": {
                return R.ok().data((Object)new LiuchengUserVo(userEntity));
            }
            case "fenxi": {
                FenxiUserVo fenxiUserVo = new FenxiUserVo(userEntity);
                if (fenxiUserVo.getCity() == null) {
                    return R.error().data(map).message("\u7528\u6237\u4e0d\u5b58\u5728");
                }
                return R.ok().data((Object)fenxiUserVo);
            }
            case "daping": {
                DapingUserVo dapingUserVo = new DapingUserVo(userEntity);
                if (dapingUserVo.getCity() == null) {
                    return R.error().data(map).message("\u7528\u6237\u4e0d\u5b58\u5728");
                }
                return R.ok().data((Object)dapingUserVo);
            }
            case "yuce": {
                YuceUserVo yuceUserVo = new YuceUserVo(userEntity);
                if (yuceUserVo.getCity() == null) {
                    return R.error().data(map).message("\u7528\u6237\u4e0d\u5b58\u5728");
                }
                return R.ok().data((Object)yuceUserVo);
            }
            case "heidianku": {
                HeidiankuUserVo heidiankuUserVo = new HeidiankuUserVo(userEntity);
                if (heidiankuUserVo.getCity() == null) {
                    return R.error().data(map).message("\u7528\u6237\u4e0d\u5b58\u5728");
                }
                return R.ok().data((Object)heidiankuUserVo);
            }
        }
        return R.error().message("\u5f53\u524d\u5141\u8bb8\u7684system\u4e3a: liucheng/fenxi/daping/yuce/heidianku");
    }
}

