/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.nokia.dao.UserDao;
import com.nokia.dao.UserRoleCityDao;
import com.nokia.pojo.Area;
import com.nokia.pojo.Role;
import com.nokia.pojo.User;
import com.nokia.pojo.UserRoleCity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserService
extends ServiceImpl<UserDao, User> {
    private final UserDao userDao;
    private final UserRoleCityDao userRoleCityDao;

    @Autowired
    public UserService(UserDao userDao, UserRoleCityDao userRoleCityDao) {
        this.userDao = userDao;
        this.userRoleCityDao = userRoleCityDao;
    }

    public boolean hasLoginName(String loginName) {
        return null != this.userDao.hasLoginName(loginName);
    }

    public boolean hasRoleCity(User user, Role role, Area city) {
        return null != this.userRoleCityDao.hasRoleCity(user.getUserId(), role.getRoleId(), city.getAreaId());
    }

    @Transactional
    public String add(User user) {
        User query = new User();
        query.setLoginName(user.getLoginName());
        User one = (User)((UserDao)this.baseMapper).selectOne((Wrapper)Wrappers.query((Object)query));
        if (one != null) {
            return "loginName: " + user.getLoginName() + " \u5df2\u5b58\u5728";
        }
        user.setCityId(user.getCity().getAreaId());
        ((UserDao)this.baseMapper).insert(user);
        return "ok";
    }

    public void addUserRoleCity(UserRoleCity userRoleCity) {
        this.userRoleCityDao.insert((Object)userRoleCity);
    }

    public User getByLoginName(String loginName) {
        return this.userDao.getByLoginName(loginName);
    }
}

