/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.service;

import com.nokia.dao.UserDao;
import com.nokia.pojo.User;
import com.nokia.service.DopService;
import com.nokia.service.TopService;
import com.nokia.vo.TokenFlagVo;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AclService {
    private static final Logger log = LoggerFactory.getLogger(AclService.class);
    @Value(value="${redis.timeoutSeconds:600}")
    private Integer timeoutSeconds;
    private final UserDao userDao;
    private final TopService topService;
    private final DopService dopService;
    private final RedisTemplate<String, Object> redisTemplate;

    @Autowired
    public AclService(UserDao userDao, TopService topService, DopService dopService, RedisTemplate<String, Object> redisTemplate) {
        this.userDao = userDao;
        this.topService = topService;
        this.dopService = dopService;
        this.redisTemplate = redisTemplate;
    }

    public User verifySystem(String token, String fromSystem) {
        User userEntity = null;
        userEntity = (User)this.redisTemplate.opsForValue().get((Object)token);
        if (userEntity != null) {
            log.debug("redis\u67e5\u8be2\u6210\u529f: {}", (Object)userEntity);
            this.redisTemplate.opsForValue().set((Object)token, (Object)userEntity, (long)this.timeoutSeconds.intValue(), TimeUnit.SECONDS);
            return userEntity;
        }
        TokenFlagVo tokenFlagVo = this.getVerifyResult(token, fromSystem);
        if (tokenFlagVo != null && tokenFlagVo.isValid()) {
            userEntity = this.userDao.getByLoginName(tokenFlagVo.getLoginName());
            if (userEntity != null) {
                this.redisTemplate.opsForValue().set((Object)token, (Object)userEntity, (long)this.timeoutSeconds.intValue(), TimeUnit.SECONDS);
            }
            return userEntity;
        }
        return null;
    }

    private TokenFlagVo getVerifyResult(String token, String fromSystem) {
        if (fromSystem.trim().equalsIgnoreCase("dop")) {
            return this.dopService.dopReturn(token);
        }
        if (fromSystem.trim().equalsIgnoreCase("top")) {
            return this.topService.topReturn(token);
        }
        if (fromSystem.trim().equalsIgnoreCase("test")) {
            return this.testToken(token);
        }
        return null;
    }

    private TokenFlagVo testToken(String token) {
        String login_name = token.trim().toLowerCase();
        login_name = login_name.replace("test_token_", "test_");
        return new TokenFlagVo(Integer.valueOf(0), login_name);
    }
}

