/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.controller;

import com.alibaba.fastjson.JSONObject;
import com.nokia.common.R;
import com.nokia.pojo.Role;
import com.nokia.service.FlowService;
import com.nokia.vo.flow.FlowRoleCityVo;
import com.nokia.vo.flow.FlowUserVo;
import com.nokia.vo.flow.UserTreeReq;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"rest"})
public class FlowApiController {
    private static final Logger log = LoggerFactory.getLogger(FlowApiController.class);
    private final FlowService flowService;

    @Autowired
    public FlowApiController(FlowService flowService) {
        this.flowService = flowService;
    }

    @PostMapping(value={"flow/api/userTree"})
    public R getUserTree(@RequestBody UserTreeReq userTreeReq) {
        log.debug("\u63a5\u6536\u5230\u5165\u53c2...{}", (Object)userTreeReq);
        List userTree = this.flowService.getUserTree(userTreeReq);
        log.debug("\u8fd4\u56de\u7ed3\u679c...{}", (Object)userTree);
        return R.ok().data((Object)userTree);
    }

    @PostMapping(value={"flow/api/getPhoneListByRole"})
    public R getPhoneListByRole(@RequestBody JSONObject req) {
        log.debug("\u63a5\u6536\u5230\u5165\u53c2...{}", (Object)req);
        try {
            int roleId = req.getIntValue("roleId");
            int cityId = req.getIntValue("cityId");
            List phoneList = this.flowService.getPhoneListByRole(roleId, cityId);
            log.debug("\u8fd4\u56de\u7ed3\u679c...{}", (Object)phoneList);
            return R.ok().data((Object)phoneList);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return R.error().message("roleId\u548ccityId\u5fc5\u9700\u4e3a\u6709\u610f\u4e49\u7684\u6574\u6570");
        }
    }

    @PostMapping(value={"flow/api"})
    @ResponseBody
    public R flowApi(@RequestBody JSONObject jsonObject) {
        log.debug("\u63a5\u6536\u5230\u5165\u53c2...{}", (Object)jsonObject);
        String callType = jsonObject.getString("callType");
        if (callType == null) {
            return R.error().message("\u8f93\u5165\u5fc5\u987b\u5305\u542bcallType");
        }
        switch (callType) {
            case "findRoleList": {
                return this.findRoleList(jsonObject);
            }
            case "findToPage": {
                return this.findToPage();
            }
            case "getByLoginId": {
                return this.getByLoginId(jsonObject);
            }
            case "get": {
                return this.get(jsonObject);
            }
            case "findRoleIdByUserId": {
                return this.findRoleIdByUserId(jsonObject);
            }
            case "findUserIdByRoleId": {
                return this.findUserIdByRoleId(jsonObject);
            }
            case "findAuthorizedUser": {
                return this.findAuthorizedUser(jsonObject);
            }
            case "getRoleCityByUserId": {
                return this.getRoleCityByUserId(jsonObject);
            }
        }
        return R.error().message("callType\u7c7b\u578b\u9519\u8bef");
    }

    private R getRoleCityByUserId(JSONObject jsonObject) {
        Integer userId = jsonObject.getInteger("userId");
        if (null == userId) {
            return R.error().message("\u8f93\u5165\u5fc5\u987b\u5305\u542buserId");
        }
        ArrayList<FlowRoleCityVo> flowRoleCityVos = new ArrayList<FlowRoleCityVo>();
        for (Role role : this.flowService.getRoleCityByUserId(userId)) {
            log.debug("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)role);
            if (!"flow".equals(role.getSystem())) continue;
            flowRoleCityVos.add(new FlowRoleCityVo(role));
        }
        log.debug("\u8fd4\u56de\u7ed3\u679c...{}", flowRoleCityVos);
        return R.ok().data(flowRoleCityVos);
    }

    public R findRoleList(JSONObject jsonObject) {
        String username = jsonObject.getString("userName");
        if (username == null || username.equals("")) {
            return R.ok().data((Object)this.flowService.findRoleList());
        }
        List roleList = this.flowService.findRoleList(username);
        log.debug("\u8fd4\u56de\u7ed3\u679c...{}", (Object)roleList);
        return R.ok().data((Object)roleList);
    }

    public R findToPage() {
        List flowUserVos = this.flowService.findToPage();
        log.debug("\u8fd4\u56de\u7ed3\u679c...{}", (Object)flowUserVos);
        return R.ok().data((Object)flowUserVos);
    }

    public R getByLoginId(JSONObject jsonObject) {
        String loginId = jsonObject.getString("loginId");
        if (loginId == null || loginId.equals("")) {
            return R.error().message("\u8f93\u5165\u5fc5\u987b\u5305\u542bloginId");
        }
        FlowUserVo flowUserVo = this.flowService.getByLoginId(loginId);
        log.debug("\u8fd4\u56de\u7ed3\u679c...{}", (Object)flowUserVo);
        return R.ok().data((Object)flowUserVo);
    }

    public R get(JSONObject jsonObject) {
        Integer userId = null;
        try {
            userId = jsonObject.getInteger("userId");
        }
        catch (NumberFormatException e) {
            return R.error().message("\u8f93\u5165\u7684userId\u5fc5\u987b\u4e3a\u6574\u6570\u683c\u5f0f");
        }
        if (userId == null) {
            return R.error().message("\u8f93\u5165\u5fc5\u987b\u5305\u542buserId");
        }
        FlowUserVo flowUserVo = this.flowService.getByUserId(userId);
        log.debug("\u8fd4\u56de\u7ed3\u679c...{}", (Object)flowUserVo);
        return R.ok().data((Object)flowUserVo);
    }

    public R findRoleIdByUserId(JSONObject jsonObject) {
        Integer userId = null;
        try {
            userId = jsonObject.getInteger("userId");
        }
        catch (NumberFormatException e) {
            return R.error().message("\u8f93\u5165\u7684userId\u5fc5\u987b\u4e3a\u6574\u6570\u683c\u5f0f");
        }
        if (userId == null) {
            return R.error().message("\u8f93\u5165\u5fc5\u987b\u5305\u542buserId");
        }
        List roleIdList = this.flowService.findRoleIdByUserId(userId);
        log.debug("\u8fd4\u56de\u7ed3\u679c...{}", (Object)roleIdList);
        return R.ok().data((Object)roleIdList);
    }

    public R findUserIdByRoleId(JSONObject jsonObject) {
        Integer roleId = null;
        try {
            roleId = jsonObject.getInteger("roleId");
        }
        catch (NumberFormatException e) {
            return R.error().message("\u8f93\u5165\u7684roleId\u5fc5\u987b\u4e3a\u6574\u6570\u683c\u5f0f");
        }
        if (roleId == null) {
            return R.error().message("\u8f93\u5165\u5fc5\u987b\u5305\u542broleId");
        }
        List userIdList = this.flowService.findUserIdByRoleId(roleId);
        log.debug("\u8fd4\u56de\u7ed3\u679c...{}", (Object)userIdList);
        return R.ok().data((Object)userIdList);
    }

    public R findAuthorizedUser(JSONObject jsonObject) {
        String loginId = jsonObject.getString("loginId");
        loginId = loginId == null || loginId.equals("") ? null : loginId.trim();
        Integer roleId = null;
        try {
            roleId = jsonObject.getInteger("roleId");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String userName = jsonObject.getString("userName");
        userName = userName == null || userName.equals("") ? null : userName.trim();
        List flowUserVos = this.flowService.findAuthorizedUser(loginId, roleId, userName);
        log.debug("\u8fd4\u56de\u7ed3\u679c...{}", (Object)flowUserVos);
        return R.ok().data((Object)flowUserVos);
    }
}

